import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.test.Utils;
import kz.gamma.tsp.TimeStampResponse;
import kz.gamma.tsp.TimeStampToken;
import kz.gamma.util.encoders.Base64;

import java.security.Security;
import java.security.cert.X509Certificate;

public class TspValidateSimple {
    public static void main(String[] args) throws Exception {
        try {
            Security.addProvider(new GammaTechProvider());
            byte[] tspCert = Base64.decode("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");
            byte[] tsp = Base64.decode("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");

            TimeStampResponse response = new TimeStampResponse(tsp);
            TimeStampToken tsToken = response.getTimeStampToken();
            System.out.println("is validated: " + checkTSPResponce(tsToken, Utils.getCertFromByteArray(tspCert)));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkTSPResponce(TimeStampToken tsToken, X509Certificate tspCert) {
        boolean ret = false;
        try {
            tsToken.validate(tspCert, "GAMMA");
            ret = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}
